import Toast from "react-native-toast-message";

const useCustomToast = () => {
	const showToast = ({ text1, text2, ...args }) => {
		/*
            NOTE: ...args should be
            ------------------------
            type: success, error, info, addToCart, undo, common & custom
            position: top / bottom,
            visibilityTime: 4000,
            topOffset: 40,
            bottomOffset: 40,
            keyboardOffset: 10
            props: {variant: error, success},
        */
		Toast.show({
			text1,
			text2,
            bottomOffset: -10,
			...args,
		});
	};
	return showToast;
};

export default useCustomToast;
